const express = require("express");
const router = express.Router();
const tableName = require("../../Utils/allTableNames");
const { GlobalInsert } = require("../../GlobalFunctions/GlobalCreate");
const RESPONSE = require("../../GlobalResponse/RESPONSE");

router.post("/createShiftDetails", (req, res) => {
  if (!req.body.shiftName || !req.body.startTime || !req.body.endTime) {
    return res.status(400).send(RESPONSE(false, "Please Fill All fields", {}));
  }
  let payload = {
    tableName: tableName.ShiftDetails,
    databaseFields: {
      shiftName: req.body.shiftName,
      startTime: req.body.startTime,
      endTime: req.body.endTime,
    },
  };
  GlobalInsert(payload, res);
});

module.exports = router;
