const express = require("express");
const router = express.Router();
const path = require("path");
const multer = require("multer");
const fs = require("fs");
const bcrypt = require("bcryptjs");
const RESPONSE = require("../../GlobalResponse/RESPONSE");
const pool = require("../../Utils/db");
const tableNames = require("../../Utils/allTableNames");

const storage = multer.diskStorage({
  // https://www.npmjs.com/package/multer#diskstorage
  destination: "public/uploads",
  filename: function (req, file, cb) {
    cb(null, `image-${new Date().getTime()}.${file.mimetype.split("/")[1]}`);
  },
});
var upload = multer({ storage: storage });

router.get("/getProfileImage", (req, res) => {
  const uploadDirectory = path.join("uploads");

  fs.readdir(uploadDirectory, (err, files) => {
    if (err) {
      return res.status(500).json({
        error: err,
        message: "Erro from server",
      });
    }
    if (files.length === 0) {
      return res.status(401).json({
        message: "No Images uploaded!",
      });
    }
    return res.status(200).json({
      files: files,
      message: "get image succussfully",
    });
  });
});

router.post("/uploadImage", upload.any("image"), (req, res, next) => {
  // const url = 'https' + "://" + req.get("host");     .......when deploying use this
  const url = "https" + "://" + req.get("host");
  const image = url + "/uploads/" + req.files[0].filename;
  const id = req.body.id;

  let uQuery = `update digita87_active_directory.users set 
    profileUrl="${image}"
    where id=${id}`;

  try {
    pool.getConnection(async (err, connection) => {
      if (err) {
        // // console.log("eror while creating connection", err);
        return res.send(RESPONSE(false, "database error", {}));
      }
      connection.query(uQuery, (err, result) => {
        connection.release();
        if (err) {
          return res.send(RESPONSE(false, "error while inserting", {}));
        } else {
          // // console.log("result");
          return res.send(
            RESPONSE(true, "User profile pic uploaded Successfully", result)
          );
        }
      });
    });
  } catch (err) {
    return res.send(RESPONSE(false, err.message, err));
  }
});

router.post("/updateUser", (req, res) => {
  let id = req.body.id;
  let username = req.body.username;
  let departName = req.body.departName;
  let isAdmin = req.body.isAdmin;
  // let password = req.body.password;

  const payload = {
    tableName: tableNames.users,
  };

  try {
    pool.getConnection((err, connection) => {
      if (err) {
        res.send(RESPONSE(false, "database error", {}));
        throw err;
      }
      connection.query(
        `SELECT * FROM ${payload.tableName} WHERE id=${id}`,
        (err, result) => {
          connection.release();

          if (err) {
            return res.send(RESPONSE(false, "error while selecting", err));
          } else {
            let updateQuery = `update ${payload.tableName} set 
              username='${username}', 
              isAdmin='${isAdmin}',
              departName= '${departName}'
              where id=${id}`;
            pool.getConnection(async (err, connection) => {
              if (err) {
                return res.send(RESPONSE(false, "database error", {}));
              }
              connection.query(updateQuery, (err, result) => {
                connection.release();
                if (err) {
                  return res.send(RESPONSE(false, "error while inserting", {}));
                } else {
                  return res.send(
                    RESPONSE(true, "updated Succesfully", result)
                  );
                }
              });
            });
            // // ===================================IF Password is matched ====================================================================>
            // // ===================================IF Password is matched ====================================================================>
            // if (result[0] && result[0].password === password) {
            //   console.log("");
            //   let updateQuery = `update ${payload.tableName} set
            //   username='${username}',
            //   password='${password}',
            //   isAdmin='${isAdmin}',
            //   departName= '${departName}'
            //   where id=${id}`;
            //   pool.getConnection(async (err, connection) => {
            //     if (err) {
            //       return res.send(RESPONSE(false, "database error", {}));
            //     }
            //     connection.query(updateQuery, (err, result) => {
            //       connection.release();
            //       if (err) {
            //         return res.send(
            //           RESPONSE(false, "error while inserting", {})
            //         );
            //       } else {
            //         return res.send(
            //           RESPONSE(true, "updated Succesfully", result)
            //         );
            //       }
            //     });
            //   });
            // } else {
            //   // ============================================== IF Password is Not matched ====================================================================>
            //   // ============================================== IF Password is Not matched ====================================================================>
            //   bcrypt.hash(password, 14, function (err, hash) {
            //     if (err) {
            //       return res.status(500).json({
            //         message: "Error while hashing",
            //         error: err,
            //       });
            //     } else {
            //       let updateQueryWithPassword = `update ${payload.tableName} set
            //                                  username='${username}',
            //                                  password='${hash}',
            //                                  isAdmin='${isAdmin}',
            //                                  departName = '${departName}'
            //                                  where id=${id}`;
            //       pool.getConnection(async (err, connection) => {
            //         if (err) {
            //           return res.send(RESPONSE(false, "database error", {}));
            //         }
            //         connection.query(updateQueryWithPassword, (err, result) => {
            //           connection.release();
            //           if (err) {
            //             return res.send(
            //               RESPONSE(false, "error while inserting", {})
            //             );
            //           } else {
            //             return res.send(
            //               RESPONSE(true, "updated Succesfully", result)
            //             );
            //           }
            //         });
            //       });
            //     }
            //   });
            // }
          }
        }
      );
    });
  } catch (err) {
    return res.send(RESPONSE(false, err.message, err));
  }
});

module.exports = router;
